c. $Id: main.f,v 1.3 2006/01/06 12:55:54 rnelias Exp $
c.
c. THIS PROGRAM CONVERTS A HEXAHEDRA MESH INTO A TETRAHEDRA MESH
c. =============================================================
c. 
c. AUTHOR: Renato N. Elias (rnelias@gmail.com)
c. DATE  : 6th of January, 2006
c.
c. Hexahedra elements are subdivided into 5 or 6 tetrahedra according 
c. to the algorithm described in: 
c.
c. Julien Dompierre, Paul Labbe, Marie-Gabrielle Vallet, Ricardo Camarero, 
c. "How to Subdivide Pyramids, Prisms and Hexahedra into Tetrahedra" 
c.
c.  (this paper is easily found in the Citeseer website or Googling)
c.
c. GENERAL NOTES: 
c.
c. - The algorithm which this program is based is very fast and no neighbooring 
c.   information regarding the elements is needed.
c.
c. - As cited in the article above, this program can be extented to split
c.   prisms and pyramids elements too;
c.
c. - The kernel of this program is in defs.f90, hextotet.f and tools.f files;
c.
c. - Any comments are welcome
c.
c. !!!!! MOST IMPORTANT NOTE !!!!!
C.
c. - This is the first release, so, TAKE CARE! Bugs are expected!!!!
c.
c. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
c.
c. BASIC INSTRUCTIONS:
c.
c. - The program will ask you for the radical name used in the file names
c.
c. INPUT FILE:
c. - The main input file is the [radical].hex file where the program expect
c.   to read the hexahedra conectivities, e.g:
c.
c. first line: 
c.      nnoel, nelh (where nnoel is 8 for hexahedra and nelh is the number 
c.                   of hexahedra to be read)
c.
c. other lines:
c.     n1, n2, n3, n4, n5, n6, n7, n8 (where "n" is the global number of the node)
c.
c. OUTPUT FILE:
c. - The program will save a [radical].tet file containing the tetrahedra conectivity
c.
c. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
      program AllToTet

      implicit real*8 (a-h,o-z)

      integer, allocatable :: ienh(:,:), ient(:,:)
      character :: radical*20

      write(*,*) ' Radical for file names: '
      read (*,*) radical

      ! Reading file with the hexahedra conectivity
      write(*,*) ' Reading hexahedra mesh...'
      open (10,file=trim(radical)//'.hex')
      read (10,*) nnoel, nelh
      allocate(ienh(nnoel,nelh))
      read (10,*) ((ienh(i,j),i=1,nnoel),j=1,nelh)
      close(10)

      ! Allocating array to store the tetrahedra elements
      ! the number of tetrahedra must be estimated around 6 x the number of hexs
      nelt = 6*nelh
      allocate(ient(4,nelt))

      ! Call HexToTet routine to build the tets employing the hexs nodes
      write(*,*) ' Subdividing hexs into tets'
      call HexToTet(ienh(1,1), nelh, ient(1,1), nelt)
      write(*,*) nelt, ' tets were built from', nelh, ' hexs'

      ! writing tetrahedra conectivity
      write(*,*) ' Writing tetrahedra conectivity'
      open (10, file=trim(radical)//'.tet')
      write(10,'(4I8)') ((ient(j,i),j=1,4),i=1,nelt)
      close(10)

      ! Writing batch file to open the tetrahedra mesh file in the PMVis program
      !
      ! NOTE1: PMVis can be downloaded from:
      ! http://www-users.cs.umn.edu/~oztekin/pmvis/
      !
      ! NOTE2: YOU WILL NEED TO SUPPLY THE NODE COORDINATES IN A *.xyz FILE
      ! ACCORDING TO PMVIS FORMAT (SEE THE EXAMPLE.XYZ FILE)
      open (10, file=trim(radical)//'.bat')
      write(10,5) trim(radical)//'.xyz', trim(radical)//'.tet' 
    5 format( 'pmvis -n ',A,' -c ',A,' -o 1 -g tet' )
      close(10)

      end program
