      subroutine HexToTet(ienhex, nelhex, ientet, neltet)

      use HexMaps

      implicit none

      integer, parameter :: nnoel = 8
      integer :: SmallestVertex, BinToDec
      integer :: i, j, irot, nelhex, neltet, ke, NumRot, NumDiags, 
     .           ns, nt, ndec
      integer, dimension(nnoel, nelhex) :: ienhex
      integer, dimension(nnoel        ) :: lnodes, lnodes_rot
      integer, dimension(4            ) :: q1, q2, q3
      integer, dimension(3            ) :: bitmask
      integer, dimension(4, 6         ) :: tet
      integer, dimension(4, neltet    ) :: ientet

      nt = 0

      do ke=1,nelhex

         ! Recovering the hexahedra's nodes
         lnodes(:) = ienhex(:,ke)

         ! Finding the rotation to be applied
         irot = SmallestVertex(lnodes(1), nnoel)

         ! applying local rotation
         do i=1,nnoel
            j = idx(irot,i)
            lnodes_rot(i) = lnodes(j)
         enddo

         bitmask(:) = 0

         ! Bit mask for the first quadrilateral face
         q1(:) = lnodes_rot(f1(:))
         j = SmallestVertex(q1(1), 4)
         if (j.eq.1 .or. j.eq.3) bitmask(1) = 1

         ! Bit mask for the second quadrilateral face
         q2(:) = lnodes_rot(f2(:))
         j = SmallestVertex(q2(1), 4)
         if (j.eq.2 .or. j.eq.4) bitmask(2) = 1

         ! Bit mask for the third quadrilateral face
         q3(:) = lnodes_rot(f3(:))
         j = SmallestVertex(q3(1), 4)
         if (j.eq.1 .or. j.eq.3) bitmask(3) = 1

         ! Decimal number correspongin to the bitmask
         ndec = BinToDec(bitmask(1))

         ! Number of hexahedra rotations (120 degrees x NumRot)
         NumRot = Rot(ndec)

         ! Applying NumRot hexahedra rotations
         call RotateHexa(lnodes_rot(1), NumRot)

         ! Number of diagonals that goes through vertex 7
         NumDiags = bitmask(1)+bitmask(2)+bitmask(3)

         ns = 6 ! number of tetrahedra to be built

         ! Recovering the tetrahedra split map
         select case (NumDiags)
           case (0)
             tet(:,:) = t0(:,:); ns = 5
           case (1)
             tet(:,:) = t1(:,:)
           case (2)
             tet(:,:) = t2(:,:)
           case (3)
             tet(:,:) = t3(:,:)
         end select
 
         ! Building "ns" tetrahedra according to the "tet" node map
         do i=1,ns
            nt = nt+1
            ientet(:,nt) = lnodes_rot(tet(:,i))
         enddo

      enddo

      neltet = nt

      end subroutine
