!
! All tables written here were copied from the following article:
! Julien Dompierre et al, "How to Subdivide Pyramids, Prisms and Hexahedra into Tetrahedra
! this paper is easily found in the citeseer website
!
module HexMaps

integer, dimension(8,8) :: idx

data &
idx(1,1), idx(1,2), idx(1,3), idx(1,4), idx(1,5), idx(1,6), idx(1,7), idx(1,8), &
idx(2,1), idx(2,2), idx(2,3), idx(2,4), idx(2,5), idx(2,6), idx(2,7), idx(2,8), &
idx(3,1), idx(3,2), idx(3,3), idx(3,4), idx(3,5), idx(3,6), idx(3,7), idx(3,8), &
idx(4,1), idx(4,2), idx(4,3), idx(4,4), idx(4,5), idx(4,6), idx(4,7), idx(4,8), &
idx(5,1), idx(5,2), idx(5,3), idx(5,4), idx(5,5), idx(5,6), idx(5,7), idx(5,8), &
idx(6,1), idx(6,2), idx(6,3), idx(6,4), idx(6,5), idx(6,6), idx(6,7), idx(6,8), &
idx(7,1), idx(7,2), idx(7,3), idx(7,4), idx(7,5), idx(7,6), idx(7,7), idx(7,8), &
idx(8,1), idx(8,2), idx(8,3), idx(8,4), idx(8,5), idx(8,6), idx(8,7), idx(8,8)/ &
1       , 2       , 3       , 4       , 5       , 6       , 7       , 8       , &
2       , 1       , 5       , 6       , 3       , 4       , 8       , 7       , &
3       , 2       , 6       , 7       , 4       , 1       , 5       , 8       , &
4       , 1       , 2       , 3       , 8       , 5       , 6       , 7       , &
5       , 1       , 4       , 8       , 6       , 2       , 3       , 7       , &
6       , 2       , 1       , 5       , 7       , 3       , 4       , 8       , &
7       , 3       , 2       , 6       , 8       , 4       , 1       , 5       , &
8       , 4       , 3       , 7       , 5       , 1       , 2       , 6       /

integer, dimension(4) :: f1
data f1(1), f1(2), f1(3), f1(4) / 2, 3, 7, 6 /

integer, dimension(4) :: f2
data f2(1), f2(2), f2(3), f2(4) / 3, 4, 8, 7 /

integer, dimension(4) :: f3
data f3(1), f3(2), f3(3), f3(4) / 5, 6, 7, 8 /

integer, dimension(0:7) :: rot
data &
rot(0), rot(1), rot(2), rot(3), rot(4), rot(5), rot(6), rot(7) / &
    0 ,     1 ,     2 ,     0 ,     0 ,     2 ,     1 ,     0  /

integer, dimension(4,6) :: t0
data &
t0(1,1), t0(1,2), t0(1,3), t0(1,4), t0(1,5), t0(1,6), &
t0(2,1), t0(2,2), t0(2,3), t0(2,4), t0(2,5), t0(2,6), &
t0(3,1), t0(3,2), t0(3,3), t0(3,4), t0(3,5), t0(3,6), &
t0(4,1), t0(4,2), t0(4,3), t0(4,4), t0(4,5), t0(4,6)/ &
1      , 1      , 1      , 1      , 3      , -1     , &
2      , 3      , 3      , 6      , 8      , -1     , &
3      , 8      , 4      , 8      , 6      , -1     , &
6      , 6      , 8      , 5      , 7      , -1     /

integer, dimension(4,6) :: t1
data &
t1(1,1), t1(1,2), t1(1,3), t1(1,4), t1(1,5), t1(1,6), &
t1(2,1), t1(2,2), t1(2,3), t1(2,4), t1(2,5), t1(2,6), &
t1(3,1), t1(3,2), t1(3,3), t1(3,4), t1(3,5), t1(3,6), &
t1(4,1), t1(4,2), t1(4,3), t1(4,4), t1(4,5), t1(4,6)/ &
1      , 1      , 2      , 1      , 1      , 2      , &
6      , 2      , 7      , 8      , 8      , 8      , &
8      , 8      , 8      , 3      , 2      , 7      , &
5      , 6      , 6      , 4      , 3      , 3      /

integer, dimension(4,6) :: t2
data &
t2(1,1), t2(1,2), t2(1,3), t2(1,4), t2(1,5), t2(1,6), &
t2(2,1), t2(2,2), t2(2,3), t2(2,4), t2(2,5), t2(2,6), &
t2(3,1), t2(3,2), t2(3,3), t2(3,4), t2(3,5), t2(3,6), &
t2(4,1), t2(4,2), t2(4,3), t2(4,4), t2(4,5), t2(4,6)/ &
1      , 1      , 1      , 1      , 1      , 1      , &
5      , 4      , 8      , 2      , 4      , 7      , &
6      , 8      , 5      , 3      , 7      , 6      , &
7      , 7      , 7      , 6      , 3      , 3      /

integer, dimension(4,6) :: t3
data &
t3(1,1), t3(1,2), t3(1,3), t3(1,4), t3(1,5), t3(1,6), &
t3(2,1), t3(2,2), t3(2,3), t3(2,4), t3(2,5), t3(2,6), &
t3(3,1), t3(3,2), t3(3,3), t3(3,4), t3(3,5), t3(3,6), &
t3(4,1), t3(4,2), t3(4,3), t3(4,4), t3(4,5), t3(4,6)/ &
1      , 1      , 1      , 1      , 2      , 2      , &
3      , 4      , 8      , 6      , 6      , 7      , &
4      , 8      , 5      , 7      , 7      , 3      , &
7      , 7      , 7      , 5      , 1      , 1      /

end module HexMaps